package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketInvoice;
import com.xforceplus.imagesaas.service.ICompareTicketInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketInvoiceController {

  @Autowired
  private ICompareTicketInvoiceService compareTicketInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketInvoice ${table.comment}
   * @return
   */
  @GetMapping("/compareticketinvoices" )
  public XfR getCompareTicketInvoices(XfPage page, CompareTicketInvoice compareTicketInvoice) {
    return XfR.ok(compareTicketInvoiceServiceImpl.page(page, Wrappers.query(compareTicketInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareticketinvoices")
  public XfR save(@RequestBody CompareTicketInvoice compareTicketInvoice) {
     return XfR.ok(compareTicketInvoiceServiceImpl.save(compareTicketInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareticketinvoices/{id}")
  public XfR putUpdate(@RequestBody CompareTicketInvoice compareTicketInvoice,@PathVariable Long id) {
      compareTicketInvoice.setId(id);
      return XfR.ok(compareTicketInvoiceServiceImpl.updateById(compareTicketInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareticketinvoices/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketInvoice compareTicketInvoice,@PathVariable Long id) {
      CompareTicketInvoice upcompareTicketInvoice = compareTicketInvoiceServiceImpl.getById(id);
      if(upcompareTicketInvoice != null){
        upcompareTicketInvoice = ObjectCopyUtils.copyProperties(compareTicketInvoice,upcompareTicketInvoice,true);
      }
      return XfR.ok(compareTicketInvoiceServiceImpl.updateById(upcompareTicketInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_invoice");
     params.put("request", condition);

     return XfR.ok(compareTicketInvoiceServiceImpl.querys(params));
  }

}
