package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketMany;
import com.xforceplus.imagesaas.service.ICompareTicketManyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketManyController {

  @Autowired
  private ICompareTicketManyService compareTicketManyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketMany ${table.comment}
   * @return
   */
  @GetMapping("/compareticketmanys" )
  public XfR getCompareTicketManys(XfPage page, CompareTicketMany compareTicketMany) {
    return XfR.ok(compareTicketManyServiceImpl.page(page, Wrappers.query(compareTicketMany)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketmanys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketManyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketMany ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareticketmanys")
  public XfR save(@RequestBody CompareTicketMany compareTicketMany) {
     return XfR.ok(compareTicketManyServiceImpl.save(compareTicketMany));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketMany ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareticketmanys/{id}")
  public XfR putUpdate(@RequestBody CompareTicketMany compareTicketMany,@PathVariable Long id) {
      compareTicketMany.setId(id);
      return XfR.ok(compareTicketManyServiceImpl.updateById(compareTicketMany));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketMany ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareticketmanys/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketMany compareTicketMany,@PathVariable Long id) {
      CompareTicketMany upcompareTicketMany = compareTicketManyServiceImpl.getById(id);
      if(upcompareTicketMany != null){
        upcompareTicketMany = ObjectCopyUtils.copyProperties(compareTicketMany,upcompareTicketMany,true);
      }
      return XfR.ok(compareTicketManyServiceImpl.updateById(upcompareTicketMany));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketmanys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketManyServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketmanys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_many");
     params.put("request", condition);

     return XfR.ok(compareTicketManyServiceImpl.querys(params));
  }

}
