package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketPlane;
import com.xforceplus.imagesaas.service.ICompareTicketPlaneService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketPlaneController {

  @Autowired
  private ICompareTicketPlaneService compareTicketPlaneServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketPlane ${table.comment}
   * @return
   */
  @GetMapping("/compareticketplanes" )
  public XfR getCompareTicketPlanes(XfPage page, CompareTicketPlane compareTicketPlane) {
    return XfR.ok(compareTicketPlaneServiceImpl.page(page, Wrappers.query(compareTicketPlane)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketplanes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketPlaneServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketPlane ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareticketplanes")
  public XfR save(@RequestBody CompareTicketPlane compareTicketPlane) {
     return XfR.ok(compareTicketPlaneServiceImpl.save(compareTicketPlane));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketPlane ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareticketplanes/{id}")
  public XfR putUpdate(@RequestBody CompareTicketPlane compareTicketPlane,@PathVariable Long id) {
      compareTicketPlane.setId(id);
      return XfR.ok(compareTicketPlaneServiceImpl.updateById(compareTicketPlane));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketPlane ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareticketplanes/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketPlane compareTicketPlane,@PathVariable Long id) {
      CompareTicketPlane upcompareTicketPlane = compareTicketPlaneServiceImpl.getById(id);
      if(upcompareTicketPlane != null){
        upcompareTicketPlane = ObjectCopyUtils.copyProperties(compareTicketPlane,upcompareTicketPlane,true);
      }
      return XfR.ok(compareTicketPlaneServiceImpl.updateById(upcompareTicketPlane));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketplanes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketPlaneServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketplanes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_plane");
     params.put("request", condition);

     return XfR.ok(compareTicketPlaneServiceImpl.querys(params));
  }

}
