package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketQuota;
import com.xforceplus.imagesaas.service.ICompareTicketQuotaService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketQuotaController {

  @Autowired
  private ICompareTicketQuotaService compareTicketQuotaServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketQuota ${table.comment}
   * @return
   */
  @GetMapping("/compareticketquotas" )
  public XfR getCompareTicketQuotas(XfPage page, CompareTicketQuota compareTicketQuota) {
    return XfR.ok(compareTicketQuotaServiceImpl.page(page, Wrappers.query(compareTicketQuota)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketquotas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketQuotaServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketQuota ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareticketquotas")
  public XfR save(@RequestBody CompareTicketQuota compareTicketQuota) {
     return XfR.ok(compareTicketQuotaServiceImpl.save(compareTicketQuota));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketQuota ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareticketquotas/{id}")
  public XfR putUpdate(@RequestBody CompareTicketQuota compareTicketQuota,@PathVariable Long id) {
      compareTicketQuota.setId(id);
      return XfR.ok(compareTicketQuotaServiceImpl.updateById(compareTicketQuota));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketQuota ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareticketquotas/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketQuota compareTicketQuota,@PathVariable Long id) {
      CompareTicketQuota upcompareTicketQuota = compareTicketQuotaServiceImpl.getById(id);
      if(upcompareTicketQuota != null){
        upcompareTicketQuota = ObjectCopyUtils.copyProperties(compareTicketQuota,upcompareTicketQuota,true);
      }
      return XfR.ok(compareTicketQuotaServiceImpl.updateById(upcompareTicketQuota));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketquotas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketQuotaServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketquotas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_quota");
     params.put("request", condition);

     return XfR.ok(compareTicketQuotaServiceImpl.querys(params));
  }

}
