package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketTrain;
import com.xforceplus.imagesaas.service.ICompareTicketTrainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketTrainController {

  @Autowired
  private ICompareTicketTrainService compareTicketTrainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketTrain ${table.comment}
   * @return
   */
  @GetMapping("/comparetickettrains" )
  public XfR getCompareTicketTrains(XfPage page, CompareTicketTrain compareTicketTrain) {
    return XfR.ok(compareTicketTrainServiceImpl.page(page, Wrappers.query(compareTicketTrain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparetickettrains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketTrainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketTrain ${table.comment}
   * @return XfR
   */
  @PostMapping("/comparetickettrains")
  public XfR save(@RequestBody CompareTicketTrain compareTicketTrain) {
     return XfR.ok(compareTicketTrainServiceImpl.save(compareTicketTrain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketTrain ${table.comment}
   * @return XfR
   */
  @PutMapping("/comparetickettrains/{id}")
  public XfR putUpdate(@RequestBody CompareTicketTrain compareTicketTrain,@PathVariable Long id) {
      compareTicketTrain.setId(id);
      return XfR.ok(compareTicketTrainServiceImpl.updateById(compareTicketTrain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketTrain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/comparetickettrains/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketTrain compareTicketTrain,@PathVariable Long id) {
      CompareTicketTrain upcompareTicketTrain = compareTicketTrainServiceImpl.getById(id);
      if(upcompareTicketTrain != null){
        upcompareTicketTrain = ObjectCopyUtils.copyProperties(compareTicketTrain,upcompareTicketTrain,true);
      }
      return XfR.ok(compareTicketTrainServiceImpl.updateById(upcompareTicketTrain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparetickettrains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketTrainServiceImpl.removeById(id));
  }

  @PostMapping("/comparetickettrains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_train");
     params.put("request", condition);

     return XfR.ok(compareTicketTrainServiceImpl.querys(params));
  }

}
