package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketUsedCar;
import com.xforceplus.imagesaas.service.ICompareTicketUsedCarService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketUsedCarController {

  @Autowired
  private ICompareTicketUsedCarService compareTicketUsedCarServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketUsedCar ${table.comment}
   * @return
   */
  @GetMapping("/compareticketusedcars" )
  public XfR getCompareTicketUsedCars(XfPage page, CompareTicketUsedCar compareTicketUsedCar) {
    return XfR.ok(compareTicketUsedCarServiceImpl.page(page, Wrappers.query(compareTicketUsedCar)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketusedcars/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketUsedCarServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketUsedCar ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareticketusedcars")
  public XfR save(@RequestBody CompareTicketUsedCar compareTicketUsedCar) {
     return XfR.ok(compareTicketUsedCarServiceImpl.save(compareTicketUsedCar));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketUsedCar ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareticketusedcars/{id}")
  public XfR putUpdate(@RequestBody CompareTicketUsedCar compareTicketUsedCar,@PathVariable Long id) {
      compareTicketUsedCar.setId(id);
      return XfR.ok(compareTicketUsedCarServiceImpl.updateById(compareTicketUsedCar));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketUsedCar ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareticketusedcars/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketUsedCar compareTicketUsedCar,@PathVariable Long id) {
      CompareTicketUsedCar upcompareTicketUsedCar = compareTicketUsedCarServiceImpl.getById(id);
      if(upcompareTicketUsedCar != null){
        upcompareTicketUsedCar = ObjectCopyUtils.copyProperties(compareTicketUsedCar,upcompareTicketUsedCar,true);
      }
      return XfR.ok(compareTicketUsedCarServiceImpl.updateById(upcompareTicketUsedCar));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketusedcars/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketUsedCarServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketusedcars/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_used_car");
     params.put("request", condition);

     return XfR.ok(compareTicketUsedCarServiceImpl.querys(params));
  }

}
