package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketVehicle;
import com.xforceplus.imagesaas.service.ICompareTicketVehicleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketVehicleController {

  @Autowired
  private ICompareTicketVehicleService compareTicketVehicleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketVehicle ${table.comment}
   * @return
   */
  @GetMapping("/compareticketvehicles" )
  public XfR getCompareTicketVehicles(XfPage page, CompareTicketVehicle compareTicketVehicle) {
    return XfR.ok(compareTicketVehicleServiceImpl.page(page, Wrappers.query(compareTicketVehicle)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketvehicles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketVehicleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketVehicle ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareticketvehicles")
  public XfR save(@RequestBody CompareTicketVehicle compareTicketVehicle) {
     return XfR.ok(compareTicketVehicleServiceImpl.save(compareTicketVehicle));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketVehicle ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareticketvehicles/{id}")
  public XfR putUpdate(@RequestBody CompareTicketVehicle compareTicketVehicle,@PathVariable Long id) {
      compareTicketVehicle.setId(id);
      return XfR.ok(compareTicketVehicleServiceImpl.updateById(compareTicketVehicle));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketVehicle ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareticketvehicles/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketVehicle compareTicketVehicle,@PathVariable Long id) {
      CompareTicketVehicle upcompareTicketVehicle = compareTicketVehicleServiceImpl.getById(id);
      if(upcompareTicketVehicle != null){
        upcompareTicketVehicle = ObjectCopyUtils.copyProperties(compareTicketVehicle,upcompareTicketVehicle,true);
      }
      return XfR.ok(compareTicketVehicleServiceImpl.updateById(upcompareTicketVehicle));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketvehicles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketVehicleServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketvehicles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_vehicle");
     params.put("request", condition);

     return XfR.ok(compareTicketVehicleServiceImpl.querys(params));
  }

}
