package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketVirtual;
import com.xforceplus.imagesaas.service.ICompareTicketVirtualService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketVirtualController {

  @Autowired
  private ICompareTicketVirtualService compareTicketVirtualServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketVirtual ${table.comment}
   * @return
   */
  @GetMapping("/compareticketvirtuals" )
  public XfR getCompareTicketVirtuals(XfPage page, CompareTicketVirtual compareTicketVirtual) {
    return XfR.ok(compareTicketVirtualServiceImpl.page(page, Wrappers.query(compareTicketVirtual)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketvirtuals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketVirtualServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketVirtual ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareticketvirtuals")
  public XfR save(@RequestBody CompareTicketVirtual compareTicketVirtual) {
     return XfR.ok(compareTicketVirtualServiceImpl.save(compareTicketVirtual));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketVirtual ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareticketvirtuals/{id}")
  public XfR putUpdate(@RequestBody CompareTicketVirtual compareTicketVirtual,@PathVariable Long id) {
      compareTicketVirtual.setId(id);
      return XfR.ok(compareTicketVirtualServiceImpl.updateById(compareTicketVirtual));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketVirtual ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareticketvirtuals/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketVirtual compareTicketVirtual,@PathVariable Long id) {
      CompareTicketVirtual upcompareTicketVirtual = compareTicketVirtualServiceImpl.getById(id);
      if(upcompareTicketVirtual != null){
        upcompareTicketVirtual = ObjectCopyUtils.copyProperties(compareTicketVirtual,upcompareTicketVirtual,true);
      }
      return XfR.ok(compareTicketVirtualServiceImpl.updateById(upcompareTicketVirtual));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketvirtuals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketVirtualServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketvirtuals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_virtual");
     params.put("request", condition);

     return XfR.ok(compareTicketVirtualServiceImpl.querys(params));
  }

}
