package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.ConfigDataMapping;
import com.xforceplus.imagesaas.service.IConfigDataMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class ConfigDataMappingController {

  @Autowired
  private IConfigDataMappingService configDataMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configDataMapping ${table.comment}
   * @return
   */
  @GetMapping("/configdatamappings" )
  public XfR getConfigDataMappings(XfPage page, ConfigDataMapping configDataMapping) {
    return XfR.ok(configDataMappingServiceImpl.page(page, Wrappers.query(configDataMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/configdatamappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configDataMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param configDataMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/configdatamappings")
  public XfR save(@RequestBody ConfigDataMapping configDataMapping) {
     return XfR.ok(configDataMappingServiceImpl.save(configDataMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param configDataMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/configdatamappings/{id}")
  public XfR putUpdate(@RequestBody ConfigDataMapping configDataMapping,@PathVariable Long id) {
      configDataMapping.setId(id);
      return XfR.ok(configDataMappingServiceImpl.updateById(configDataMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param configDataMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/configdatamappings/{id}")
  public XfR patchUpdate(@RequestBody ConfigDataMapping configDataMapping,@PathVariable Long id) {
      ConfigDataMapping upconfigDataMapping = configDataMappingServiceImpl.getById(id);
      if(upconfigDataMapping != null){
        upconfigDataMapping = ObjectCopyUtils.copyProperties(configDataMapping,upconfigDataMapping,true);
      }
      return XfR.ok(configDataMappingServiceImpl.updateById(upconfigDataMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configdatamappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configDataMappingServiceImpl.removeById(id));
  }

  @PostMapping("/configdatamappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_data_mapping");
     params.put("request", condition);

     return XfR.ok(configDataMappingServiceImpl.querys(params));
  }

}
