package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.StatementBill;
import com.xforceplus.imagesaas.service.IStatementBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class StatementBillController {

  @Autowired
  private IStatementBillService statementBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param statementBill ${table.comment}
   * @return
   */
  @GetMapping("/statementbills" )
  public XfR getStatementBills(XfPage page, StatementBill statementBill) {
    return XfR.ok(statementBillServiceImpl.page(page, Wrappers.query(statementBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/statementbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(statementBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param statementBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/statementbills")
  public XfR save(@RequestBody StatementBill statementBill) {
     return XfR.ok(statementBillServiceImpl.save(statementBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param statementBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/statementbills/{id}")
  public XfR putUpdate(@RequestBody StatementBill statementBill,@PathVariable Long id) {
      statementBill.setId(id);
      return XfR.ok(statementBillServiceImpl.updateById(statementBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param statementBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/statementbills/{id}")
  public XfR patchUpdate(@RequestBody StatementBill statementBill,@PathVariable Long id) {
      StatementBill upstatementBill = statementBillServiceImpl.getById(id);
      if(upstatementBill != null){
        upstatementBill = ObjectCopyUtils.copyProperties(statementBill,upstatementBill,true);
      }
      return XfR.ok(statementBillServiceImpl.updateById(upstatementBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statementbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(statementBillServiceImpl.removeById(id));
  }

  @PostMapping("/statementbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "statement_bill");
     params.put("request", condition);

     return XfR.ok(statementBillServiceImpl.querys(params));
  }

}
