package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.Testdeploy;
import com.xforceplus.imagesaas.service.ITestdeployService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class TestdeployController {

  @Autowired
  private ITestdeployService testdeployServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testdeploy ${table.comment}
   * @return
   */
  @GetMapping("/testdeploys" )
  public XfR getTestdeploys(XfPage page, Testdeploy testdeploy) {
    return XfR.ok(testdeployServiceImpl.page(page, Wrappers.query(testdeploy)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testdeploys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testdeployServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testdeploy ${table.comment}
   * @return XfR
   */
  @PostMapping("/testdeploys")
  public XfR save(@RequestBody Testdeploy testdeploy) {
     return XfR.ok(testdeployServiceImpl.save(testdeploy));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testdeploy ${table.comment}
   * @return XfR
   */
  @PutMapping("/testdeploys/{id}")
  public XfR putUpdate(@RequestBody Testdeploy testdeploy,@PathVariable Long id) {
      testdeploy.setId(id);
      return XfR.ok(testdeployServiceImpl.updateById(testdeploy));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testdeploy ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testdeploys/{id}")
  public XfR patchUpdate(@RequestBody Testdeploy testdeploy,@PathVariable Long id) {
      Testdeploy uptestdeploy = testdeployServiceImpl.getById(id);
      if(uptestdeploy != null){
        uptestdeploy = ObjectCopyUtils.copyProperties(testdeploy,uptestdeploy,true);
      }
      return XfR.ok(testdeployServiceImpl.updateById(uptestdeploy));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testdeploys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testdeployServiceImpl.removeById(id));
  }

  @PostMapping("/testdeploys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testdeploy");
     params.put("request", condition);

     return XfR.ok(testdeployServiceImpl.querys(params));
  }

}
