package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.TicketUsedCar;
import com.xforceplus.imagesaas.service.ITicketUsedCarService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class TicketUsedCarController {

  @Autowired
  private ITicketUsedCarService ticketUsedCarServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketUsedCar ${table.comment}
   * @return
   */
  @GetMapping("/ticketusedcars" )
  public XfR getTicketUsedCars(XfPage page, TicketUsedCar ticketUsedCar) {
    return XfR.ok(ticketUsedCarServiceImpl.page(page, Wrappers.query(ticketUsedCar)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketusedcars/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketUsedCarServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketUsedCar ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketusedcars")
  public XfR save(@RequestBody TicketUsedCar ticketUsedCar) {
     return XfR.ok(ticketUsedCarServiceImpl.save(ticketUsedCar));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketUsedCar ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketusedcars/{id}")
  public XfR putUpdate(@RequestBody TicketUsedCar ticketUsedCar,@PathVariable Long id) {
      ticketUsedCar.setId(id);
      return XfR.ok(ticketUsedCarServiceImpl.updateById(ticketUsedCar));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketUsedCar ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketusedcars/{id}")
  public XfR patchUpdate(@RequestBody TicketUsedCar ticketUsedCar,@PathVariable Long id) {
      TicketUsedCar upticketUsedCar = ticketUsedCarServiceImpl.getById(id);
      if(upticketUsedCar != null){
        upticketUsedCar = ObjectCopyUtils.copyProperties(ticketUsedCar,upticketUsedCar,true);
      }
      return XfR.ok(ticketUsedCarServiceImpl.updateById(upticketUsedCar));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketusedcars/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketUsedCarServiceImpl.removeById(id));
  }

  @PostMapping("/ticketusedcars/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_used_car");
     params.put("request", condition);

     return XfR.ok(ticketUsedCarServiceImpl.querys(params));
  }

}
