package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.TicketWarning;
import com.xforceplus.imagesaas.service.ITicketWarningService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class TicketWarningController {

  @Autowired
  private ITicketWarningService ticketWarningServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketWarning ${table.comment}
   * @return
   */
  @GetMapping("/ticketwarnings" )
  public XfR getTicketWarnings(XfPage page, TicketWarning ticketWarning) {
    return XfR.ok(ticketWarningServiceImpl.page(page, Wrappers.query(ticketWarning)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketwarnings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketWarningServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketWarning ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketwarnings")
  public XfR save(@RequestBody TicketWarning ticketWarning) {
     return XfR.ok(ticketWarningServiceImpl.save(ticketWarning));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketWarning ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketwarnings/{id}")
  public XfR putUpdate(@RequestBody TicketWarning ticketWarning,@PathVariable Long id) {
      ticketWarning.setId(id);
      return XfR.ok(ticketWarningServiceImpl.updateById(ticketWarning));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketWarning ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketwarnings/{id}")
  public XfR patchUpdate(@RequestBody TicketWarning ticketWarning,@PathVariable Long id) {
      TicketWarning upticketWarning = ticketWarningServiceImpl.getById(id);
      if(upticketWarning != null){
        upticketWarning = ObjectCopyUtils.copyProperties(ticketWarning,upticketWarning,true);
      }
      return XfR.ok(ticketWarningServiceImpl.updateById(upticketWarning));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketwarnings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketWarningServiceImpl.removeById(id));
  }

  @PostMapping("/ticketwarnings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_warning");
     params.put("request", condition);

     return XfR.ok(ticketWarningServiceImpl.querys(params));
  }

}
