package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.FyHtfk;
import com.xforceplus.imagesaas.service.IFyHtfkService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 中南置地-费控合同付款前端控制器
 *
 * @author ultraman
 * @date 2022-03-04
 */
@RestController
public class FyHtfkController {

  @Autowired
  private IFyHtfkService fyHtfkServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fyHtfk 中南置地-费控合同付款
   * @return
   */
  @GetMapping("/fyhtfks" )
  public XfR getFyHtfks(XfPage page, FyHtfk fyHtfk) {
    return XfR.ok(fyHtfkServiceImpl.page(page, Wrappers.query(fyHtfk)));
  }

  /**
   * 通过id查询中南置地-费控合同付款
   * @param  id
   * @return XfR
   */
  @GetMapping("/fyhtfks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fyHtfkServiceImpl.getById(id));
  }

  /**
   * 新增中南置地-费控合同付款
   * @param fyHtfk 中南置地-费控合同付款
   * @return XfR
   */
  @PostMapping("/fyhtfks")
  public XfR save(@RequestBody FyHtfk fyHtfk) {
     return XfR.ok(fyHtfkServiceImpl.save(fyHtfk));
  }

  /**
   * 修改-传入修改后的全部数据中南置地-费控合同付款
   * @param fyHtfk 中南置地-费控合同付款
   * @return XfR
   */
  @PutMapping("/fyhtfks/{id}")
  public XfR putUpdate(@RequestBody FyHtfk fyHtfk,@PathVariable Long id) {
      fyHtfk.setId(id);
      return XfR.ok(fyHtfkServiceImpl.updateById(fyHtfk));
  }

  /**
   * 修改-传入修改的数据中南置地-费控合同付款
   * @param fyHtfk 中南置地-费控合同付款
   * @return XfR
   */
  @PatchMapping("/fyhtfks/{id}")
  public XfR patchUpdate(@RequestBody FyHtfk fyHtfk,@PathVariable Long id) {
      FyHtfk upfyHtfk = fyHtfkServiceImpl.getById(id);
      if(upfyHtfk != null){
        upfyHtfk = ObjectCopyUtils.copyProperties(fyHtfk,upfyHtfk,true);
      }
      return XfR.ok(fyHtfkServiceImpl.updateById(upfyHtfk));
  }

  /**
   * 通过id删除中南置地-费控合同付款
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fyhtfks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fyHtfkServiceImpl.removeById(id));
  }

  @PostMapping("/fyhtfks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fy_htfk");
     params.put("request", condition);

     return XfR.ok(fyHtfkServiceImpl.querys(params));
  }

}
