package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.TicketOther;
import com.xforceplus.imagesaas.service.ITicketOtherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 其他发票前端控制器
 *
 * @author ultraman
 * @date 2022-03-04
 */
@RestController
public class TicketOtherController {

  @Autowired
  private ITicketOtherService ticketOtherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketOther 其他发票
   * @return
   */
  @GetMapping("/ticketothers" )
  public XfR getTicketOthers(XfPage page, TicketOther ticketOther) {
    return XfR.ok(ticketOtherServiceImpl.page(page, Wrappers.query(ticketOther)));
  }

  /**
   * 通过id查询其他发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketothers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketOtherServiceImpl.getById(id));
  }

  /**
   * 新增其他发票
   * @param ticketOther 其他发票
   * @return XfR
   */
  @PostMapping("/ticketothers")
  public XfR save(@RequestBody TicketOther ticketOther) {
     return XfR.ok(ticketOtherServiceImpl.save(ticketOther));
  }

  /**
   * 修改-传入修改后的全部数据其他发票
   * @param ticketOther 其他发票
   * @return XfR
   */
  @PutMapping("/ticketothers/{id}")
  public XfR putUpdate(@RequestBody TicketOther ticketOther,@PathVariable Long id) {
      ticketOther.setId(id);
      return XfR.ok(ticketOtherServiceImpl.updateById(ticketOther));
  }

  /**
   * 修改-传入修改的数据其他发票
   * @param ticketOther 其他发票
   * @return XfR
   */
  @PatchMapping("/ticketothers/{id}")
  public XfR patchUpdate(@RequestBody TicketOther ticketOther,@PathVariable Long id) {
      TicketOther upticketOther = ticketOtherServiceImpl.getById(id);
      if(upticketOther != null){
        upticketOther = ObjectCopyUtils.copyProperties(ticketOther,upticketOther,true);
      }
      return XfR.ok(ticketOtherServiceImpl.updateById(upticketOther));
  }

  /**
   * 通过id删除其他发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketothers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketOtherServiceImpl.removeById(id));
  }

  @PostMapping("/ticketothers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_other");
     params.put("request", condition);

     return XfR.ok(ticketOtherServiceImpl.querys(params));
  }

}
