package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.TicketToll;
import com.xforceplus.imagesaas.service.ITicketTollService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-03-04
 */
@RestController
public class TicketTollController {

  @Autowired
  private ITicketTollService ticketTollServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketToll ${table.comment}
   * @return
   */
  @GetMapping("/tickettolls" )
  public XfR getTicketTolls(XfPage page, TicketToll ticketToll) {
    return XfR.ok(ticketTollServiceImpl.page(page, Wrappers.query(ticketToll)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tickettolls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketTollServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketToll ${table.comment}
   * @return XfR
   */
  @PostMapping("/tickettolls")
  public XfR save(@RequestBody TicketToll ticketToll) {
     return XfR.ok(ticketTollServiceImpl.save(ticketToll));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketToll ${table.comment}
   * @return XfR
   */
  @PutMapping("/tickettolls/{id}")
  public XfR putUpdate(@RequestBody TicketToll ticketToll,@PathVariable Long id) {
      ticketToll.setId(id);
      return XfR.ok(ticketTollServiceImpl.updateById(ticketToll));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketToll ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tickettolls/{id}")
  public XfR patchUpdate(@RequestBody TicketToll ticketToll,@PathVariable Long id) {
      TicketToll upticketToll = ticketTollServiceImpl.getById(id);
      if(upticketToll != null){
        upticketToll = ObjectCopyUtils.copyProperties(ticketToll,upticketToll,true);
      }
      return XfR.ok(ticketTollServiceImpl.updateById(upticketToll));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tickettolls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketTollServiceImpl.removeById(id));
  }

  @PostMapping("/tickettolls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_toll");
     params.put("request", condition);

     return XfR.ok(ticketTollServiceImpl.querys(params));
  }

}
