package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.TicketVirtual;
import com.xforceplus.imagesaas.service.ITicketVirtualService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 虚拟单证前端控制器
 *
 * @author ultraman
 * @date 2022-03-04
 */
@RestController
public class TicketVirtualController {

  @Autowired
  private ITicketVirtualService ticketVirtualServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketVirtual 虚拟单证
   * @return
   */
  @GetMapping("/ticketvirtuals" )
  public XfR getTicketVirtuals(XfPage page, TicketVirtual ticketVirtual) {
    return XfR.ok(ticketVirtualServiceImpl.page(page, Wrappers.query(ticketVirtual)));
  }

  /**
   * 通过id查询虚拟单证
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketvirtuals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketVirtualServiceImpl.getById(id));
  }

  /**
   * 新增虚拟单证
   * @param ticketVirtual 虚拟单证
   * @return XfR
   */
  @PostMapping("/ticketvirtuals")
  public XfR save(@RequestBody TicketVirtual ticketVirtual) {
     return XfR.ok(ticketVirtualServiceImpl.save(ticketVirtual));
  }

  /**
   * 修改-传入修改后的全部数据虚拟单证
   * @param ticketVirtual 虚拟单证
   * @return XfR
   */
  @PutMapping("/ticketvirtuals/{id}")
  public XfR putUpdate(@RequestBody TicketVirtual ticketVirtual,@PathVariable Long id) {
      ticketVirtual.setId(id);
      return XfR.ok(ticketVirtualServiceImpl.updateById(ticketVirtual));
  }

  /**
   * 修改-传入修改的数据虚拟单证
   * @param ticketVirtual 虚拟单证
   * @return XfR
   */
  @PatchMapping("/ticketvirtuals/{id}")
  public XfR patchUpdate(@RequestBody TicketVirtual ticketVirtual,@PathVariable Long id) {
      TicketVirtual upticketVirtual = ticketVirtualServiceImpl.getById(id);
      if(upticketVirtual != null){
        upticketVirtual = ObjectCopyUtils.copyProperties(ticketVirtual,upticketVirtual,true);
      }
      return XfR.ok(ticketVirtualServiceImpl.updateById(upticketVirtual));
  }

  /**
   * 通过id删除虚拟单证
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketvirtuals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketVirtualServiceImpl.removeById(id));
  }

  @PostMapping("/ticketvirtuals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_virtual");
     params.put("request", condition);

     return XfR.ok(ticketVirtualServiceImpl.querys(params));
  }

}
