package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.BankBill;
import com.xforceplus.imagesaas.service.IBankBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-05-26
 */
@RestController
public class BankBillController {

  @Autowired
  private IBankBillService bankBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bankBill ${table.comment}
   * @return
   */
  @GetMapping("/bankbills" )
  public XfR getBankBills(XfPage page, BankBill bankBill) {
    return XfR.ok(bankBillServiceImpl.page(page, Wrappers.query(bankBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bankbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bankBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bankBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/bankbills")
  public XfR save(@RequestBody BankBill bankBill) {
     return XfR.ok(bankBillServiceImpl.save(bankBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bankBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/bankbills/{id}")
  public XfR putUpdate(@RequestBody BankBill bankBill,@PathVariable Long id) {
      bankBill.setId(id);
      return XfR.ok(bankBillServiceImpl.updateById(bankBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bankBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bankbills/{id}")
  public XfR patchUpdate(@RequestBody BankBill bankBill,@PathVariable Long id) {
      BankBill upbankBill = bankBillServiceImpl.getById(id);
      if(upbankBill != null){
        upbankBill = ObjectCopyUtils.copyProperties(bankBill,upbankBill,true);
      }
      return XfR.ok(bankBillServiceImpl.updateById(upbankBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bankbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bankBillServiceImpl.removeById(id));
  }

  @PostMapping("/bankbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bank_bill");
     params.put("request", condition);

     return XfR.ok(bankBillServiceImpl.querys(params));
  }

}
