package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CbHtfkBl;
import com.xforceplus.imagesaas.service.ICbHtfkBlService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 中南置地-成本合同付款补录前端控制器
 *
 * @author ultraman
 * @date 2022-05-26
 */
@RestController
public class CbHtfkBlController {

  @Autowired
  private ICbHtfkBlService cbHtfkBlServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cbHtfkBl 中南置地-成本合同付款补录
   * @return
   */
  @GetMapping("/cbhtfkbls" )
  public XfR getCbHtfkBls(XfPage page, CbHtfkBl cbHtfkBl) {
    return XfR.ok(cbHtfkBlServiceImpl.page(page, Wrappers.query(cbHtfkBl)));
  }

  /**
   * 通过id查询中南置地-成本合同付款补录
   * @param  id
   * @return XfR
   */
  @GetMapping("/cbhtfkbls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cbHtfkBlServiceImpl.getById(id));
  }

  /**
   * 新增中南置地-成本合同付款补录
   * @param cbHtfkBl 中南置地-成本合同付款补录
   * @return XfR
   */
  @PostMapping("/cbhtfkbls")
  public XfR save(@RequestBody CbHtfkBl cbHtfkBl) {
     return XfR.ok(cbHtfkBlServiceImpl.save(cbHtfkBl));
  }

  /**
   * 修改-传入修改后的全部数据中南置地-成本合同付款补录
   * @param cbHtfkBl 中南置地-成本合同付款补录
   * @return XfR
   */
  @PutMapping("/cbhtfkbls/{id}")
  public XfR putUpdate(@RequestBody CbHtfkBl cbHtfkBl,@PathVariable Long id) {
      cbHtfkBl.setId(id);
      return XfR.ok(cbHtfkBlServiceImpl.updateById(cbHtfkBl));
  }

  /**
   * 修改-传入修改的数据中南置地-成本合同付款补录
   * @param cbHtfkBl 中南置地-成本合同付款补录
   * @return XfR
   */
  @PatchMapping("/cbhtfkbls/{id}")
  public XfR patchUpdate(@RequestBody CbHtfkBl cbHtfkBl,@PathVariable Long id) {
      CbHtfkBl upcbHtfkBl = cbHtfkBlServiceImpl.getById(id);
      if(upcbHtfkBl != null){
        upcbHtfkBl = ObjectCopyUtils.copyProperties(cbHtfkBl,upcbHtfkBl,true);
      }
      return XfR.ok(cbHtfkBlServiceImpl.updateById(upcbHtfkBl));
  }

  /**
   * 通过id删除中南置地-成本合同付款补录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cbhtfkbls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cbHtfkBlServiceImpl.removeById(id));
  }

  @PostMapping("/cbhtfkbls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cb_htfk_bl");
     params.put("request", condition);

     return XfR.ok(cbHtfkBlServiceImpl.querys(params));
  }

}
