package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketMachine;
import com.xforceplus.imagesaas.service.ICompareTicketMachineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的通用机打发票前端控制器
 *
 * @author ultraman
 * @date 2022-05-26
 */
@RestController
public class CompareTicketMachineController {

  @Autowired
  private ICompareTicketMachineService compareTicketMachineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketMachine 数据比对用途的通用机打发票
   * @return
   */
  @GetMapping("/compareticketmachines" )
  public XfR getCompareTicketMachines(XfPage page, CompareTicketMachine compareTicketMachine) {
    return XfR.ok(compareTicketMachineServiceImpl.page(page, Wrappers.query(compareTicketMachine)));
  }

  /**
   * 通过id查询数据比对用途的通用机打发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketmachines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketMachineServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的通用机打发票
   * @param compareTicketMachine 数据比对用途的通用机打发票
   * @return XfR
   */
  @PostMapping("/compareticketmachines")
  public XfR save(@RequestBody CompareTicketMachine compareTicketMachine) {
     return XfR.ok(compareTicketMachineServiceImpl.save(compareTicketMachine));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的通用机打发票
   * @param compareTicketMachine 数据比对用途的通用机打发票
   * @return XfR
   */
  @PutMapping("/compareticketmachines/{id}")
  public XfR putUpdate(@RequestBody CompareTicketMachine compareTicketMachine,@PathVariable Long id) {
      compareTicketMachine.setId(id);
      return XfR.ok(compareTicketMachineServiceImpl.updateById(compareTicketMachine));
  }

  /**
   * 修改-传入修改的数据数据比对用途的通用机打发票
   * @param compareTicketMachine 数据比对用途的通用机打发票
   * @return XfR
   */
  @PatchMapping("/compareticketmachines/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketMachine compareTicketMachine,@PathVariable Long id) {
      CompareTicketMachine upcompareTicketMachine = compareTicketMachineServiceImpl.getById(id);
      if(upcompareTicketMachine != null){
        upcompareTicketMachine = ObjectCopyUtils.copyProperties(compareTicketMachine,upcompareTicketMachine,true);
      }
      return XfR.ok(compareTicketMachineServiceImpl.updateById(upcompareTicketMachine));
  }

  /**
   * 通过id删除数据比对用途的通用机打发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketmachines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketMachineServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketmachines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_machine");
     params.put("request", condition);

     return XfR.ok(compareTicketMachineServiceImpl.querys(params));
  }

}
