package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.OrgInfo;
import com.xforceplus.imagesaas.service.IOrgInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-05-26
 */
@RestController
public class OrgInfoController {

  @Autowired
  private IOrgInfoService orgInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orgInfo ${table.comment}
   * @return
   */
  @GetMapping("/orginfos" )
  public XfR getOrgInfos(XfPage page, OrgInfo orgInfo) {
    return XfR.ok(orgInfoServiceImpl.page(page, Wrappers.query(orgInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orginfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orgInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orgInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/orginfos")
  public XfR save(@RequestBody OrgInfo orgInfo) {
     return XfR.ok(orgInfoServiceImpl.save(orgInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orgInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/orginfos/{id}")
  public XfR putUpdate(@RequestBody OrgInfo orgInfo,@PathVariable Long id) {
      orgInfo.setId(id);
      return XfR.ok(orgInfoServiceImpl.updateById(orgInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orgInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orginfos/{id}")
  public XfR patchUpdate(@RequestBody OrgInfo orgInfo,@PathVariable Long id) {
      OrgInfo uporgInfo = orgInfoServiceImpl.getById(id);
      if(uporgInfo != null){
        uporgInfo = ObjectCopyUtils.copyProperties(orgInfo,uporgInfo,true);
      }
      return XfR.ok(orgInfoServiceImpl.updateById(uporgInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orginfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orgInfoServiceImpl.removeById(id));
  }

  @PostMapping("/orginfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "org_info");
     params.put("request", condition);

     return XfR.ok(orgInfoServiceImpl.querys(params));
  }

}
