package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.PrivateBill;
import com.xforceplus.imagesaas.service.IPrivateBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-05-26
 */
@RestController
public class PrivateBillController {

  @Autowired
  private IPrivateBillService privateBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param privateBill ${table.comment}
   * @return
   */
  @GetMapping("/privatebills" )
  public XfR getPrivateBills(XfPage page, PrivateBill privateBill) {
    return XfR.ok(privateBillServiceImpl.page(page, Wrappers.query(privateBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/privatebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(privateBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param privateBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/privatebills")
  public XfR save(@RequestBody PrivateBill privateBill) {
     return XfR.ok(privateBillServiceImpl.save(privateBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param privateBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/privatebills/{id}")
  public XfR putUpdate(@RequestBody PrivateBill privateBill,@PathVariable Long id) {
      privateBill.setId(id);
      return XfR.ok(privateBillServiceImpl.updateById(privateBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param privateBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/privatebills/{id}")
  public XfR patchUpdate(@RequestBody PrivateBill privateBill,@PathVariable Long id) {
      PrivateBill upprivateBill = privateBillServiceImpl.getById(id);
      if(upprivateBill != null){
        upprivateBill = ObjectCopyUtils.copyProperties(privateBill,upprivateBill,true);
      }
      return XfR.ok(privateBillServiceImpl.updateById(upprivateBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/privatebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(privateBillServiceImpl.removeById(id));
  }

  @PostMapping("/privatebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "private_bill");
     params.put("request", condition);

     return XfR.ok(privateBillServiceImpl.querys(params));
  }

}
