package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.ComparePublicBill;
import com.xforceplus.imagesaas.service.IComparePublicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的对公业务单前端控制器
 *
 * @author ultraman
 * @date 2022-06-30
 */
@RestController
public class ComparePublicBillController {

  @Autowired
  private IComparePublicBillService comparePublicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param comparePublicBill 数据比对用途的对公业务单
   * @return
   */
  @GetMapping("/comparepublicbills" )
  public XfR getComparePublicBills(XfPage page, ComparePublicBill comparePublicBill) {
    return XfR.ok(comparePublicBillServiceImpl.page(page, Wrappers.query(comparePublicBill)));
  }

  /**
   * 通过id查询数据比对用途的对公业务单
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparepublicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(comparePublicBillServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的对公业务单
   * @param comparePublicBill 数据比对用途的对公业务单
   * @return XfR
   */
  @PostMapping("/comparepublicbills")
  public XfR save(@RequestBody ComparePublicBill comparePublicBill) {
     return XfR.ok(comparePublicBillServiceImpl.save(comparePublicBill));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的对公业务单
   * @param comparePublicBill 数据比对用途的对公业务单
   * @return XfR
   */
  @PutMapping("/comparepublicbills/{id}")
  public XfR putUpdate(@RequestBody ComparePublicBill comparePublicBill,@PathVariable Long id) {
      comparePublicBill.setId(id);
      return XfR.ok(comparePublicBillServiceImpl.updateById(comparePublicBill));
  }

  /**
   * 修改-传入修改的数据数据比对用途的对公业务单
   * @param comparePublicBill 数据比对用途的对公业务单
   * @return XfR
   */
  @PatchMapping("/comparepublicbills/{id}")
  public XfR patchUpdate(@RequestBody ComparePublicBill comparePublicBill,@PathVariable Long id) {
      ComparePublicBill upcomparePublicBill = comparePublicBillServiceImpl.getById(id);
      if(upcomparePublicBill != null){
        upcomparePublicBill = ObjectCopyUtils.copyProperties(comparePublicBill,upcomparePublicBill,true);
      }
      return XfR.ok(comparePublicBillServiceImpl.updateById(upcomparePublicBill));
  }

  /**
   * 通过id删除数据比对用途的对公业务单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparepublicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(comparePublicBillServiceImpl.removeById(id));
  }

  @PostMapping("/comparepublicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_public_bill");
     params.put("request", condition);

     return XfR.ok(comparePublicBillServiceImpl.querys(params));
  }

}
