package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketCustomsDeclarationDetails;
import com.xforceplus.imagesaas.service.ICompareTicketCustomsDeclarationDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 比对报关单明细前端控制器
 *
 * @author ultraman
 * @date 2022-06-30
 */
@RestController
public class CompareTicketCustomsDeclarationDetailsController {

  @Autowired
  private ICompareTicketCustomsDeclarationDetailsService compareTicketCustomsDeclarationDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketCustomsDeclarationDetails 比对报关单明细
   * @return
   */
  @GetMapping("/compareticketcustomsdeclarationdetailss" )
  public XfR getCompareTicketCustomsDeclarationDetailss(XfPage page, CompareTicketCustomsDeclarationDetails compareTicketCustomsDeclarationDetails) {
    return XfR.ok(compareTicketCustomsDeclarationDetailsServiceImpl.page(page, Wrappers.query(compareTicketCustomsDeclarationDetails)));
  }

  /**
   * 通过id查询比对报关单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketcustomsdeclarationdetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketCustomsDeclarationDetailsServiceImpl.getById(id));
  }

  /**
   * 新增比对报关单明细
   * @param compareTicketCustomsDeclarationDetails 比对报关单明细
   * @return XfR
   */
  @PostMapping("/compareticketcustomsdeclarationdetailss")
  public XfR save(@RequestBody CompareTicketCustomsDeclarationDetails compareTicketCustomsDeclarationDetails) {
     return XfR.ok(compareTicketCustomsDeclarationDetailsServiceImpl.save(compareTicketCustomsDeclarationDetails));
  }

  /**
   * 修改-传入修改后的全部数据比对报关单明细
   * @param compareTicketCustomsDeclarationDetails 比对报关单明细
   * @return XfR
   */
  @PutMapping("/compareticketcustomsdeclarationdetailss/{id}")
  public XfR putUpdate(@RequestBody CompareTicketCustomsDeclarationDetails compareTicketCustomsDeclarationDetails,@PathVariable Long id) {
      compareTicketCustomsDeclarationDetails.setId(id);
      return XfR.ok(compareTicketCustomsDeclarationDetailsServiceImpl.updateById(compareTicketCustomsDeclarationDetails));
  }

  /**
   * 修改-传入修改的数据比对报关单明细
   * @param compareTicketCustomsDeclarationDetails 比对报关单明细
   * @return XfR
   */
  @PatchMapping("/compareticketcustomsdeclarationdetailss/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketCustomsDeclarationDetails compareTicketCustomsDeclarationDetails,@PathVariable Long id) {
      CompareTicketCustomsDeclarationDetails upcompareTicketCustomsDeclarationDetails = compareTicketCustomsDeclarationDetailsServiceImpl.getById(id);
      if(upcompareTicketCustomsDeclarationDetails != null){
        upcompareTicketCustomsDeclarationDetails = ObjectCopyUtils.copyProperties(compareTicketCustomsDeclarationDetails,upcompareTicketCustomsDeclarationDetails,true);
      }
      return XfR.ok(compareTicketCustomsDeclarationDetailsServiceImpl.updateById(upcompareTicketCustomsDeclarationDetails));
  }

  /**
   * 通过id删除比对报关单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketcustomsdeclarationdetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketCustomsDeclarationDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketcustomsdeclarationdetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_customs_declaration_details");
     params.put("request", condition);

     return XfR.ok(compareTicketCustomsDeclarationDetailsServiceImpl.querys(params));
  }

}
