package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketFinance;
import com.xforceplus.imagesaas.service.ICompareTicketFinanceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 比对财政票据前端控制器
 *
 * @author ultraman
 * @date 2022-06-30
 */
@RestController
public class CompareTicketFinanceController {

  @Autowired
  private ICompareTicketFinanceService compareTicketFinanceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketFinance 比对财政票据
   * @return
   */
  @GetMapping("/compareticketfinances" )
  public XfR getCompareTicketFinances(XfPage page, CompareTicketFinance compareTicketFinance) {
    return XfR.ok(compareTicketFinanceServiceImpl.page(page, Wrappers.query(compareTicketFinance)));
  }

  /**
   * 通过id查询比对财政票据
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketfinances/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketFinanceServiceImpl.getById(id));
  }

  /**
   * 新增比对财政票据
   * @param compareTicketFinance 比对财政票据
   * @return XfR
   */
  @PostMapping("/compareticketfinances")
  public XfR save(@RequestBody CompareTicketFinance compareTicketFinance) {
     return XfR.ok(compareTicketFinanceServiceImpl.save(compareTicketFinance));
  }

  /**
   * 修改-传入修改后的全部数据比对财政票据
   * @param compareTicketFinance 比对财政票据
   * @return XfR
   */
  @PutMapping("/compareticketfinances/{id}")
  public XfR putUpdate(@RequestBody CompareTicketFinance compareTicketFinance,@PathVariable Long id) {
      compareTicketFinance.setId(id);
      return XfR.ok(compareTicketFinanceServiceImpl.updateById(compareTicketFinance));
  }

  /**
   * 修改-传入修改的数据比对财政票据
   * @param compareTicketFinance 比对财政票据
   * @return XfR
   */
  @PatchMapping("/compareticketfinances/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketFinance compareTicketFinance,@PathVariable Long id) {
      CompareTicketFinance upcompareTicketFinance = compareTicketFinanceServiceImpl.getById(id);
      if(upcompareTicketFinance != null){
        upcompareTicketFinance = ObjectCopyUtils.copyProperties(compareTicketFinance,upcompareTicketFinance,true);
      }
      return XfR.ok(compareTicketFinanceServiceImpl.updateById(upcompareTicketFinance));
  }

  /**
   * 通过id删除比对财政票据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketfinances/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketFinanceServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketfinances/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_finance");
     params.put("request", condition);

     return XfR.ok(compareTicketFinanceServiceImpl.querys(params));
  }

}
