package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.OtherBill;
import com.xforceplus.imagesaas.service.IOtherBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-30
 */
@RestController
public class OtherBillController {

  @Autowired
  private IOtherBillService otherBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param otherBill ${table.comment}
   * @return
   */
  @GetMapping("/otherbills" )
  public XfR getOtherBills(XfPage page, OtherBill otherBill) {
    return XfR.ok(otherBillServiceImpl.page(page, Wrappers.query(otherBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/otherbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(otherBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param otherBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/otherbills")
  public XfR save(@RequestBody OtherBill otherBill) {
     return XfR.ok(otherBillServiceImpl.save(otherBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param otherBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/otherbills/{id}")
  public XfR putUpdate(@RequestBody OtherBill otherBill,@PathVariable Long id) {
      otherBill.setId(id);
      return XfR.ok(otherBillServiceImpl.updateById(otherBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param otherBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/otherbills/{id}")
  public XfR patchUpdate(@RequestBody OtherBill otherBill,@PathVariable Long id) {
      OtherBill upotherBill = otherBillServiceImpl.getById(id);
      if(upotherBill != null){
        upotherBill = ObjectCopyUtils.copyProperties(otherBill,upotherBill,true);
      }
      return XfR.ok(otherBillServiceImpl.updateById(upotherBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/otherbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(otherBillServiceImpl.removeById(id));
  }

  @PostMapping("/otherbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "other_bill");
     params.put("request", condition);

     return XfR.ok(otherBillServiceImpl.querys(params));
  }

}
