package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.TicketCustomsDeclarationDetails;
import com.xforceplus.imagesaas.service.ITicketCustomsDeclarationDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-30
 */
@RestController
public class TicketCustomsDeclarationDetailsController {

  @Autowired
  private ITicketCustomsDeclarationDetailsService ticketCustomsDeclarationDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketCustomsDeclarationDetails ${table.comment}
   * @return
   */
  @GetMapping("/ticketcustomsdeclarationdetailss" )
  public XfR getTicketCustomsDeclarationDetailss(XfPage page, TicketCustomsDeclarationDetails ticketCustomsDeclarationDetails) {
    return XfR.ok(ticketCustomsDeclarationDetailsServiceImpl.page(page, Wrappers.query(ticketCustomsDeclarationDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketcustomsdeclarationdetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsDeclarationDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketCustomsDeclarationDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketcustomsdeclarationdetailss")
  public XfR save(@RequestBody TicketCustomsDeclarationDetails ticketCustomsDeclarationDetails) {
     return XfR.ok(ticketCustomsDeclarationDetailsServiceImpl.save(ticketCustomsDeclarationDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketCustomsDeclarationDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketcustomsdeclarationdetailss/{id}")
  public XfR putUpdate(@RequestBody TicketCustomsDeclarationDetails ticketCustomsDeclarationDetails,@PathVariable Long id) {
      ticketCustomsDeclarationDetails.setId(id);
      return XfR.ok(ticketCustomsDeclarationDetailsServiceImpl.updateById(ticketCustomsDeclarationDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketCustomsDeclarationDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketcustomsdeclarationdetailss/{id}")
  public XfR patchUpdate(@RequestBody TicketCustomsDeclarationDetails ticketCustomsDeclarationDetails,@PathVariable Long id) {
      TicketCustomsDeclarationDetails upticketCustomsDeclarationDetails = ticketCustomsDeclarationDetailsServiceImpl.getById(id);
      if(upticketCustomsDeclarationDetails != null){
        upticketCustomsDeclarationDetails = ObjectCopyUtils.copyProperties(ticketCustomsDeclarationDetails,upticketCustomsDeclarationDetails,true);
      }
      return XfR.ok(ticketCustomsDeclarationDetailsServiceImpl.updateById(upticketCustomsDeclarationDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketcustomsdeclarationdetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsDeclarationDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/ticketcustomsdeclarationdetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_customs_declaration_details");
     params.put("request", condition);

     return XfR.ok(ticketCustomsDeclarationDetailsServiceImpl.querys(params));
  }

}
