package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.TicketMedical;
import com.xforceplus.imagesaas.service.ITicketMedicalService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-30
 */
@RestController
public class TicketMedicalController {

  @Autowired
  private ITicketMedicalService ticketMedicalServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketMedical ${table.comment}
   * @return
   */
  @GetMapping("/ticketmedicals" )
  public XfR getTicketMedicals(XfPage page, TicketMedical ticketMedical) {
    return XfR.ok(ticketMedicalServiceImpl.page(page, Wrappers.query(ticketMedical)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketmedicals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketMedicalServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketMedical ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketmedicals")
  public XfR save(@RequestBody TicketMedical ticketMedical) {
     return XfR.ok(ticketMedicalServiceImpl.save(ticketMedical));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketMedical ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketmedicals/{id}")
  public XfR putUpdate(@RequestBody TicketMedical ticketMedical,@PathVariable Long id) {
      ticketMedical.setId(id);
      return XfR.ok(ticketMedicalServiceImpl.updateById(ticketMedical));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketMedical ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketmedicals/{id}")
  public XfR patchUpdate(@RequestBody TicketMedical ticketMedical,@PathVariable Long id) {
      TicketMedical upticketMedical = ticketMedicalServiceImpl.getById(id);
      if(upticketMedical != null){
        upticketMedical = ObjectCopyUtils.copyProperties(ticketMedical,upticketMedical,true);
      }
      return XfR.ok(ticketMedicalServiceImpl.updateById(upticketMedical));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketmedicals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketMedicalServiceImpl.removeById(id));
  }

  @PostMapping("/ticketmedicals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_medical");
     params.put("request", condition);

     return XfR.ok(ticketMedicalServiceImpl.querys(params));
  }

}
