package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.TicketSourceFile;
import com.xforceplus.imagesaas.service.ITicketSourceFileService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-30
 */
@RestController
public class TicketSourceFileController {

  @Autowired
  private ITicketSourceFileService ticketSourceFileServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketSourceFile ${table.comment}
   * @return
   */
  @GetMapping("/ticketsourcefiles" )
  public XfR getTicketSourceFiles(XfPage page, TicketSourceFile ticketSourceFile) {
    return XfR.ok(ticketSourceFileServiceImpl.page(page, Wrappers.query(ticketSourceFile)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketsourcefiles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketSourceFileServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketSourceFile ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketsourcefiles")
  public XfR save(@RequestBody TicketSourceFile ticketSourceFile) {
     return XfR.ok(ticketSourceFileServiceImpl.save(ticketSourceFile));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketSourceFile ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketsourcefiles/{id}")
  public XfR putUpdate(@RequestBody TicketSourceFile ticketSourceFile,@PathVariable Long id) {
      ticketSourceFile.setId(id);
      return XfR.ok(ticketSourceFileServiceImpl.updateById(ticketSourceFile));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketSourceFile ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketsourcefiles/{id}")
  public XfR patchUpdate(@RequestBody TicketSourceFile ticketSourceFile,@PathVariable Long id) {
      TicketSourceFile upticketSourceFile = ticketSourceFileServiceImpl.getById(id);
      if(upticketSourceFile != null){
        upticketSourceFile = ObjectCopyUtils.copyProperties(ticketSourceFile,upticketSourceFile,true);
      }
      return XfR.ok(ticketSourceFileServiceImpl.updateById(upticketSourceFile));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketsourcefiles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketSourceFileServiceImpl.removeById(id));
  }

  @PostMapping("/ticketsourcefiles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_source_file");
     params.put("request", condition);

     return XfR.ok(ticketSourceFileServiceImpl.querys(params));
  }

}
