package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketCustomsPaymentDetail;
import com.xforceplus.imagesaas.service.ICompareTicketCustomsPaymentDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 比对海关缴款书明细前端控制器
 *
 * @author ultraman
 * @date 2023-06-27
 */
@RestController
public class CompareTicketCustomsPaymentDetailController {

  @Autowired
  private ICompareTicketCustomsPaymentDetailService compareTicketCustomsPaymentDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketCustomsPaymentDetail 比对海关缴款书明细
   * @return
   */
  @GetMapping("/compareticketcustomspaymentdetails" )
  public XfR getCompareTicketCustomsPaymentDetails(XfPage page, CompareTicketCustomsPaymentDetail compareTicketCustomsPaymentDetail) {
    return XfR.ok(compareTicketCustomsPaymentDetailServiceImpl.page(page, Wrappers.query(compareTicketCustomsPaymentDetail)));
  }

  /**
   * 通过id查询比对海关缴款书明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketcustomspaymentdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketCustomsPaymentDetailServiceImpl.getById(id));
  }

  /**
   * 新增比对海关缴款书明细
   * @param compareTicketCustomsPaymentDetail 比对海关缴款书明细
   * @return XfR
   */
  @PostMapping("/compareticketcustomspaymentdetails")
  public XfR save(@RequestBody CompareTicketCustomsPaymentDetail compareTicketCustomsPaymentDetail) {
     return XfR.ok(compareTicketCustomsPaymentDetailServiceImpl.save(compareTicketCustomsPaymentDetail));
  }

  /**
   * 修改-传入修改后的全部数据比对海关缴款书明细
   * @param compareTicketCustomsPaymentDetail 比对海关缴款书明细
   * @return XfR
   */
  @PutMapping("/compareticketcustomspaymentdetails/{id}")
  public XfR putUpdate(@RequestBody CompareTicketCustomsPaymentDetail compareTicketCustomsPaymentDetail,@PathVariable Long id) {
      compareTicketCustomsPaymentDetail.setId(id);
      return XfR.ok(compareTicketCustomsPaymentDetailServiceImpl.updateById(compareTicketCustomsPaymentDetail));
  }

  /**
   * 修改-传入修改的数据比对海关缴款书明细
   * @param compareTicketCustomsPaymentDetail 比对海关缴款书明细
   * @return XfR
   */
  @PatchMapping("/compareticketcustomspaymentdetails/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketCustomsPaymentDetail compareTicketCustomsPaymentDetail,@PathVariable Long id) {
      CompareTicketCustomsPaymentDetail upcompareTicketCustomsPaymentDetail = compareTicketCustomsPaymentDetailServiceImpl.getById(id);
      if(upcompareTicketCustomsPaymentDetail != null){
        upcompareTicketCustomsPaymentDetail = ObjectCopyUtils.copyProperties(compareTicketCustomsPaymentDetail,upcompareTicketCustomsPaymentDetail,true);
      }
      return XfR.ok(compareTicketCustomsPaymentDetailServiceImpl.updateById(upcompareTicketCustomsPaymentDetail));
  }

  /**
   * 通过id删除比对海关缴款书明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketcustomspaymentdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketCustomsPaymentDetailServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketcustomspaymentdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_customs_payment_detail");
     params.put("request", condition);

     return XfR.ok(compareTicketCustomsPaymentDetailServiceImpl.querys(params));
  }

}
