package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketInvoice;
import com.xforceplus.imagesaas.service.ICompareTicketInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 数据比对用途的增值税发票前端控制器
 *
 * @author ultraman
 * @date 2023-06-27
 */
@RestController
public class CompareTicketInvoiceController {

  @Autowired
  private ICompareTicketInvoiceService compareTicketInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketInvoice 数据比对用途的增值税发票
   * @return
   */
  @GetMapping("/compareticketinvoices" )
  public XfR getCompareTicketInvoices(XfPage page, CompareTicketInvoice compareTicketInvoice) {
    return XfR.ok(compareTicketInvoiceServiceImpl.page(page, Wrappers.query(compareTicketInvoice)));
  }

  /**
   * 通过id查询数据比对用途的增值税发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的增值税发票
   * @param compareTicketInvoice 数据比对用途的增值税发票
   * @return XfR
   */
  @PostMapping("/compareticketinvoices")
  public XfR save(@RequestBody CompareTicketInvoice compareTicketInvoice) {
     return XfR.ok(compareTicketInvoiceServiceImpl.save(compareTicketInvoice));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的增值税发票
   * @param compareTicketInvoice 数据比对用途的增值税发票
   * @return XfR
   */
  @PutMapping("/compareticketinvoices/{id}")
  public XfR putUpdate(@RequestBody CompareTicketInvoice compareTicketInvoice,@PathVariable Long id) {
      compareTicketInvoice.setId(id);
      return XfR.ok(compareTicketInvoiceServiceImpl.updateById(compareTicketInvoice));
  }

  /**
   * 修改-传入修改的数据数据比对用途的增值税发票
   * @param compareTicketInvoice 数据比对用途的增值税发票
   * @return XfR
   */
  @PatchMapping("/compareticketinvoices/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketInvoice compareTicketInvoice,@PathVariable Long id) {
      CompareTicketInvoice upcompareTicketInvoice = compareTicketInvoiceServiceImpl.getById(id);
      if(upcompareTicketInvoice != null){
        upcompareTicketInvoice = ObjectCopyUtils.copyProperties(compareTicketInvoice,upcompareTicketInvoice,true);
      }
      return XfR.ok(compareTicketInvoiceServiceImpl.updateById(upcompareTicketInvoice));
  }

  /**
   * 通过id删除数据比对用途的增值税发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_invoice");
     params.put("request", condition);

     return XfR.ok(compareTicketInvoiceServiceImpl.querys(params));
  }

}
