package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.InvoiceBus;
import com.xforceplus.imagesaas.service.IInvoiceBusService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-27
 */
@RestController
public class InvoiceBusController {

  @Autowired
  private IInvoiceBusService invoiceBusServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceBus ${table.comment}
   * @return
   */
  @GetMapping("/invoicebuss" )
  public XfR getInvoiceBuss(XfPage page, InvoiceBus invoiceBus) {
    return XfR.ok(invoiceBusServiceImpl.page(page, Wrappers.query(invoiceBus)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicebuss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceBusServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceBus ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicebuss")
  public XfR save(@RequestBody InvoiceBus invoiceBus) {
     return XfR.ok(invoiceBusServiceImpl.save(invoiceBus));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceBus ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicebuss/{id}")
  public XfR putUpdate(@RequestBody InvoiceBus invoiceBus,@PathVariable Long id) {
      invoiceBus.setId(id);
      return XfR.ok(invoiceBusServiceImpl.updateById(invoiceBus));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceBus ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicebuss/{id}")
  public XfR patchUpdate(@RequestBody InvoiceBus invoiceBus,@PathVariable Long id) {
      InvoiceBus upinvoiceBus = invoiceBusServiceImpl.getById(id);
      if(upinvoiceBus != null){
        upinvoiceBus = ObjectCopyUtils.copyProperties(invoiceBus,upinvoiceBus,true);
      }
      return XfR.ok(invoiceBusServiceImpl.updateById(upinvoiceBus));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicebuss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceBusServiceImpl.removeById(id));
  }

  @PostMapping("/invoicebuss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_bus");
     params.put("request", condition);

     return XfR.ok(invoiceBusServiceImpl.querys(params));
  }

}
