package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.Label;
import com.xforceplus.imagesaas.service.ILabelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-27
 */
@RestController
public class LabelController {

  @Autowired
  private ILabelService labelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param label ${table.comment}
   * @return
   */
  @GetMapping("/labels" )
  public XfR getLabels(XfPage page, Label label) {
    return XfR.ok(labelServiceImpl.page(page, Wrappers.query(label)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/labels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(labelServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param label ${table.comment}
   * @return XfR
   */
  @PostMapping("/labels")
  public XfR save(@RequestBody Label label) {
     return XfR.ok(labelServiceImpl.save(label));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param label ${table.comment}
   * @return XfR
   */
  @PutMapping("/labels/{id}")
  public XfR putUpdate(@RequestBody Label label,@PathVariable Long id) {
      label.setId(id);
      return XfR.ok(labelServiceImpl.updateById(label));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param label ${table.comment}
   * @return XfR
   */
  @PatchMapping("/labels/{id}")
  public XfR patchUpdate(@RequestBody Label label,@PathVariable Long id) {
      Label uplabel = labelServiceImpl.getById(id);
      if(uplabel != null){
        uplabel = ObjectCopyUtils.copyProperties(label,uplabel,true);
      }
      return XfR.ok(labelServiceImpl.updateById(uplabel));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/labels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(labelServiceImpl.removeById(id));
  }

  @PostMapping("/labels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "label");
     params.put("request", condition);

     return XfR.ok(labelServiceImpl.querys(params));
  }

}
