package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.SystemLabelsHistory;
import com.xforceplus.imagesaas.service.ISystemLabelsHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-27
 */
@RestController
public class SystemLabelsHistoryController {

  @Autowired
  private ISystemLabelsHistoryService systemLabelsHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemLabelsHistory ${table.comment}
   * @return
   */
  @GetMapping("/systemlabelshistorys" )
  public XfR getSystemLabelsHistorys(XfPage page, SystemLabelsHistory systemLabelsHistory) {
    return XfR.ok(systemLabelsHistoryServiceImpl.page(page, Wrappers.query(systemLabelsHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemlabelshistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemLabelsHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param systemLabelsHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/systemlabelshistorys")
  public XfR save(@RequestBody SystemLabelsHistory systemLabelsHistory) {
     return XfR.ok(systemLabelsHistoryServiceImpl.save(systemLabelsHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param systemLabelsHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/systemlabelshistorys/{id}")
  public XfR putUpdate(@RequestBody SystemLabelsHistory systemLabelsHistory,@PathVariable Long id) {
      systemLabelsHistory.setId(id);
      return XfR.ok(systemLabelsHistoryServiceImpl.updateById(systemLabelsHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param systemLabelsHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/systemlabelshistorys/{id}")
  public XfR patchUpdate(@RequestBody SystemLabelsHistory systemLabelsHistory,@PathVariable Long id) {
      SystemLabelsHistory upsystemLabelsHistory = systemLabelsHistoryServiceImpl.getById(id);
      if(upsystemLabelsHistory != null){
        upsystemLabelsHistory = ObjectCopyUtils.copyProperties(systemLabelsHistory,upsystemLabelsHistory,true);
      }
      return XfR.ok(systemLabelsHistoryServiceImpl.updateById(upsystemLabelsHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemlabelshistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemLabelsHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/systemlabelshistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_labels_history");
     params.put("request", condition);

     return XfR.ok(systemLabelsHistoryServiceImpl.querys(params));
  }

}
