package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.TicketFinance;
import com.xforceplus.imagesaas.service.ITicketFinanceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-27
 */
@RestController
public class TicketFinanceController {

  @Autowired
  private ITicketFinanceService ticketFinanceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketFinance ${table.comment}
   * @return
   */
  @GetMapping("/ticketfinances" )
  public XfR getTicketFinances(XfPage page, TicketFinance ticketFinance) {
    return XfR.ok(ticketFinanceServiceImpl.page(page, Wrappers.query(ticketFinance)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketfinances/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketFinanceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketFinance ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketfinances")
  public XfR save(@RequestBody TicketFinance ticketFinance) {
     return XfR.ok(ticketFinanceServiceImpl.save(ticketFinance));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketFinance ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketfinances/{id}")
  public XfR putUpdate(@RequestBody TicketFinance ticketFinance,@PathVariable Long id) {
      ticketFinance.setId(id);
      return XfR.ok(ticketFinanceServiceImpl.updateById(ticketFinance));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketFinance ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketfinances/{id}")
  public XfR patchUpdate(@RequestBody TicketFinance ticketFinance,@PathVariable Long id) {
      TicketFinance upticketFinance = ticketFinanceServiceImpl.getById(id);
      if(upticketFinance != null){
        upticketFinance = ObjectCopyUtils.copyProperties(ticketFinance,upticketFinance,true);
      }
      return XfR.ok(ticketFinanceServiceImpl.updateById(upticketFinance));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketfinances/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketFinanceServiceImpl.removeById(id));
  }

  @PostMapping("/ticketfinances/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_finance");
     params.put("request", condition);

     return XfR.ok(ticketFinanceServiceImpl.querys(params));
  }

}
