package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CheckDisplayText;
import com.xforceplus.imagesaas.service.ICheckDisplayTextService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-14
 */
@RestController
public class CheckDisplayTextController {

  @Autowired
  private ICheckDisplayTextService checkDisplayTextServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param checkDisplayText ${table.comment}
   * @return
   */
  @GetMapping("/checkdisplaytexts" )
  public XfR getCheckDisplayTexts(XfPage page, CheckDisplayText checkDisplayText) {
    return XfR.ok(checkDisplayTextServiceImpl.page(page, Wrappers.query(checkDisplayText)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/checkdisplaytexts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(checkDisplayTextServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param checkDisplayText ${table.comment}
   * @return XfR
   */
  @PostMapping("/checkdisplaytexts")
  public XfR save(@RequestBody CheckDisplayText checkDisplayText) {
     return XfR.ok(checkDisplayTextServiceImpl.save(checkDisplayText));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param checkDisplayText ${table.comment}
   * @return XfR
   */
  @PutMapping("/checkdisplaytexts/{id}")
  public XfR putUpdate(@RequestBody CheckDisplayText checkDisplayText,@PathVariable Long id) {
      checkDisplayText.setId(id);
      return XfR.ok(checkDisplayTextServiceImpl.updateById(checkDisplayText));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param checkDisplayText ${table.comment}
   * @return XfR
   */
  @PatchMapping("/checkdisplaytexts/{id}")
  public XfR patchUpdate(@RequestBody CheckDisplayText checkDisplayText,@PathVariable Long id) {
      CheckDisplayText upcheckDisplayText = checkDisplayTextServiceImpl.getById(id);
      if(upcheckDisplayText != null){
        upcheckDisplayText = ObjectCopyUtils.copyProperties(checkDisplayText,upcheckDisplayText,true);
      }
      return XfR.ok(checkDisplayTextServiceImpl.updateById(upcheckDisplayText));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/checkdisplaytexts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(checkDisplayTextServiceImpl.removeById(id));
  }

  @PostMapping("/checkdisplaytexts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "check_display_text");
     params.put("request", condition);

     return XfR.ok(checkDisplayTextServiceImpl.querys(params));
  }

}
