package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.ImageCopy;
import com.xforceplus.imagesaas.service.IImageCopyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-14
 */
@RestController
public class ImageCopyController {

  @Autowired
  private IImageCopyService imageCopyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param imageCopy ${table.comment}
   * @return
   */
  @GetMapping("/imagecopys" )
  public XfR getImageCopys(XfPage page, ImageCopy imageCopy) {
    return XfR.ok(imageCopyServiceImpl.page(page, Wrappers.query(imageCopy)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/imagecopys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(imageCopyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param imageCopy ${table.comment}
   * @return XfR
   */
  @PostMapping("/imagecopys")
  public XfR save(@RequestBody ImageCopy imageCopy) {
     return XfR.ok(imageCopyServiceImpl.save(imageCopy));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param imageCopy ${table.comment}
   * @return XfR
   */
  @PutMapping("/imagecopys/{id}")
  public XfR putUpdate(@RequestBody ImageCopy imageCopy,@PathVariable Long id) {
      imageCopy.setId(id);
      return XfR.ok(imageCopyServiceImpl.updateById(imageCopy));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param imageCopy ${table.comment}
   * @return XfR
   */
  @PatchMapping("/imagecopys/{id}")
  public XfR patchUpdate(@RequestBody ImageCopy imageCopy,@PathVariable Long id) {
      ImageCopy upimageCopy = imageCopyServiceImpl.getById(id);
      if(upimageCopy != null){
        upimageCopy = ObjectCopyUtils.copyProperties(imageCopy,upimageCopy,true);
      }
      return XfR.ok(imageCopyServiceImpl.updateById(upimageCopy));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/imagecopys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(imageCopyServiceImpl.removeById(id));
  }

  @PostMapping("/imagecopys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "image_copy");
     params.put("request", condition);

     return XfR.ok(imageCopyServiceImpl.querys(params));
  }

}
