package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.TicketFinanceDetail;
import com.xforceplus.imagesaas.service.ITicketFinanceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-14
 */
@RestController
public class TicketFinanceDetailController {

  @Autowired
  private ITicketFinanceDetailService ticketFinanceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketFinanceDetail ${table.comment}
   * @return
   */
  @GetMapping("/ticketfinancedetails" )
  public XfR getTicketFinanceDetails(XfPage page, TicketFinanceDetail ticketFinanceDetail) {
    return XfR.ok(ticketFinanceDetailServiceImpl.page(page, Wrappers.query(ticketFinanceDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketfinancedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketFinanceDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketFinanceDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketfinancedetails")
  public XfR save(@RequestBody TicketFinanceDetail ticketFinanceDetail) {
     return XfR.ok(ticketFinanceDetailServiceImpl.save(ticketFinanceDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketFinanceDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketfinancedetails/{id}")
  public XfR putUpdate(@RequestBody TicketFinanceDetail ticketFinanceDetail,@PathVariable Long id) {
      ticketFinanceDetail.setId(id);
      return XfR.ok(ticketFinanceDetailServiceImpl.updateById(ticketFinanceDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketFinanceDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketfinancedetails/{id}")
  public XfR patchUpdate(@RequestBody TicketFinanceDetail ticketFinanceDetail,@PathVariable Long id) {
      TicketFinanceDetail upticketFinanceDetail = ticketFinanceDetailServiceImpl.getById(id);
      if(upticketFinanceDetail != null){
        upticketFinanceDetail = ObjectCopyUtils.copyProperties(ticketFinanceDetail,upticketFinanceDetail,true);
      }
      return XfR.ok(ticketFinanceDetailServiceImpl.updateById(upticketFinanceDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketfinancedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketFinanceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketfinancedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_finance_detail");
     params.put("request", condition);

     return XfR.ok(ticketFinanceDetailServiceImpl.querys(params));
  }

}
