package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketCustomsPayment;
import com.xforceplus.imagesaas.service.ICompareTicketCustomsPaymentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 比对海关缴款书.前端控制器
 *
 * @author ultraman
 * @date 2023-07-31
 */
@RestController
public class CompareTicketCustomsPaymentController {

  @Autowired
  private ICompareTicketCustomsPaymentService compareTicketCustomsPaymentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketCustomsPayment 比对海关缴款书.
   * @return
   */
  @GetMapping("/compareticketcustomspayments" )
  public XfR getCompareTicketCustomsPayments(XfPage page, CompareTicketCustomsPayment compareTicketCustomsPayment) {
    return XfR.ok(compareTicketCustomsPaymentServiceImpl.page(page, Wrappers.query(compareTicketCustomsPayment)));
  }

  /**
   * 通过id查询比对海关缴款书.
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketcustomspayments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketCustomsPaymentServiceImpl.getById(id));
  }

  /**
   * 新增比对海关缴款书.
   * @param compareTicketCustomsPayment 比对海关缴款书.
   * @return XfR
   */
  @PostMapping("/compareticketcustomspayments")
  public XfR save(@RequestBody CompareTicketCustomsPayment compareTicketCustomsPayment) {
     return XfR.ok(compareTicketCustomsPaymentServiceImpl.save(compareTicketCustomsPayment));
  }

  /**
   * 修改-传入修改后的全部数据比对海关缴款书.
   * @param compareTicketCustomsPayment 比对海关缴款书.
   * @return XfR
   */
  @PutMapping("/compareticketcustomspayments/{id}")
  public XfR putUpdate(@RequestBody CompareTicketCustomsPayment compareTicketCustomsPayment,@PathVariable Long id) {
      compareTicketCustomsPayment.setId(id);
      return XfR.ok(compareTicketCustomsPaymentServiceImpl.updateById(compareTicketCustomsPayment));
  }

  /**
   * 修改-传入修改的数据比对海关缴款书.
   * @param compareTicketCustomsPayment 比对海关缴款书.
   * @return XfR
   */
  @PatchMapping("/compareticketcustomspayments/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketCustomsPayment compareTicketCustomsPayment,@PathVariable Long id) {
      CompareTicketCustomsPayment upcompareTicketCustomsPayment = compareTicketCustomsPaymentServiceImpl.getById(id);
      if(upcompareTicketCustomsPayment != null){
        upcompareTicketCustomsPayment = ObjectCopyUtils.copyProperties(compareTicketCustomsPayment,upcompareTicketCustomsPayment,true);
      }
      return XfR.ok(compareTicketCustomsPaymentServiceImpl.updateById(upcompareTicketCustomsPayment));
  }

  /**
   * 通过id删除比对海关缴款书.
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketcustomspayments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketCustomsPaymentServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketcustomspayments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_customs_payment");
     params.put("request", condition);

     return XfR.ok(compareTicketCustomsPaymentServiceImpl.querys(params));
  }

}
