package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketInvoiceDetail;
import com.xforceplus.imagesaas.service.ICompareTicketInvoiceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 数据比对用途的增值税发票明细前端控制器
 *
 * @author ultraman
 * @date 2023-07-31
 */
@RestController
public class CompareTicketInvoiceDetailController {

  @Autowired
  private ICompareTicketInvoiceDetailService compareTicketInvoiceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketInvoiceDetail 数据比对用途的增值税发票明细
   * @return
   */
  @GetMapping("/compareticketinvoicedetails" )
  public XfR getCompareTicketInvoiceDetails(XfPage page, CompareTicketInvoiceDetail compareTicketInvoiceDetail) {
    return XfR.ok(compareTicketInvoiceDetailServiceImpl.page(page, Wrappers.query(compareTicketInvoiceDetail)));
  }

  /**
   * 通过id查询数据比对用途的增值税发票明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketinvoicedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketInvoiceDetailServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的增值税发票明细
   * @param compareTicketInvoiceDetail 数据比对用途的增值税发票明细
   * @return XfR
   */
  @PostMapping("/compareticketinvoicedetails")
  public XfR save(@RequestBody CompareTicketInvoiceDetail compareTicketInvoiceDetail) {
     return XfR.ok(compareTicketInvoiceDetailServiceImpl.save(compareTicketInvoiceDetail));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的增值税发票明细
   * @param compareTicketInvoiceDetail 数据比对用途的增值税发票明细
   * @return XfR
   */
  @PutMapping("/compareticketinvoicedetails/{id}")
  public XfR putUpdate(@RequestBody CompareTicketInvoiceDetail compareTicketInvoiceDetail,@PathVariable Long id) {
      compareTicketInvoiceDetail.setId(id);
      return XfR.ok(compareTicketInvoiceDetailServiceImpl.updateById(compareTicketInvoiceDetail));
  }

  /**
   * 修改-传入修改的数据数据比对用途的增值税发票明细
   * @param compareTicketInvoiceDetail 数据比对用途的增值税发票明细
   * @return XfR
   */
  @PatchMapping("/compareticketinvoicedetails/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketInvoiceDetail compareTicketInvoiceDetail,@PathVariable Long id) {
      CompareTicketInvoiceDetail upcompareTicketInvoiceDetail = compareTicketInvoiceDetailServiceImpl.getById(id);
      if(upcompareTicketInvoiceDetail != null){
        upcompareTicketInvoiceDetail = ObjectCopyUtils.copyProperties(compareTicketInvoiceDetail,upcompareTicketInvoiceDetail,true);
      }
      return XfR.ok(compareTicketInvoiceDetailServiceImpl.updateById(upcompareTicketInvoiceDetail));
  }

  /**
   * 通过id删除数据比对用途的增值税发票明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketinvoicedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketInvoiceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketinvoicedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_invoice_detail");
     params.put("request", condition);

     return XfR.ok(compareTicketInvoiceDetailServiceImpl.querys(params));
  }

}
