package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketSalesList;
import com.xforceplus.imagesaas.service.ICompareTicketSalesListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 数据比对用途的销货清单前端控制器
 *
 * @author ultraman
 * @date 2023-07-31
 */
@RestController
public class CompareTicketSalesListController {

  @Autowired
  private ICompareTicketSalesListService compareTicketSalesListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketSalesList 数据比对用途的销货清单
   * @return
   */
  @GetMapping("/compareticketsaleslists" )
  public XfR getCompareTicketSalesLists(XfPage page, CompareTicketSalesList compareTicketSalesList) {
    return XfR.ok(compareTicketSalesListServiceImpl.page(page, Wrappers.query(compareTicketSalesList)));
  }

  /**
   * 通过id查询数据比对用途的销货清单
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketsaleslists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketSalesListServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的销货清单
   * @param compareTicketSalesList 数据比对用途的销货清单
   * @return XfR
   */
  @PostMapping("/compareticketsaleslists")
  public XfR save(@RequestBody CompareTicketSalesList compareTicketSalesList) {
     return XfR.ok(compareTicketSalesListServiceImpl.save(compareTicketSalesList));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的销货清单
   * @param compareTicketSalesList 数据比对用途的销货清单
   * @return XfR
   */
  @PutMapping("/compareticketsaleslists/{id}")
  public XfR putUpdate(@RequestBody CompareTicketSalesList compareTicketSalesList,@PathVariable Long id) {
      compareTicketSalesList.setId(id);
      return XfR.ok(compareTicketSalesListServiceImpl.updateById(compareTicketSalesList));
  }

  /**
   * 修改-传入修改的数据数据比对用途的销货清单
   * @param compareTicketSalesList 数据比对用途的销货清单
   * @return XfR
   */
  @PatchMapping("/compareticketsaleslists/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketSalesList compareTicketSalesList,@PathVariable Long id) {
      CompareTicketSalesList upcompareTicketSalesList = compareTicketSalesListServiceImpl.getById(id);
      if(upcompareTicketSalesList != null){
        upcompareTicketSalesList = ObjectCopyUtils.copyProperties(compareTicketSalesList,upcompareTicketSalesList,true);
      }
      return XfR.ok(compareTicketSalesListServiceImpl.updateById(upcompareTicketSalesList));
  }

  /**
   * 通过id删除数据比对用途的销货清单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketsaleslists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketSalesListServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketsaleslists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_sales_list");
     params.put("request", condition);

     return XfR.ok(compareTicketSalesListServiceImpl.querys(params));
  }

}
