package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.FyExpense;
import com.xforceplus.imagesaas.service.IFyExpenseService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 中南置地-费控报销前端控制器
 *
 * @author ultraman
 * @date 2023-07-31
 */
@RestController
public class FyExpenseController {

  @Autowired
  private IFyExpenseService fyExpenseServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fyExpense 中南置地-费控报销
   * @return
   */
  @GetMapping("/fyexpenses" )
  public XfR getFyExpenses(XfPage page, FyExpense fyExpense) {
    return XfR.ok(fyExpenseServiceImpl.page(page, Wrappers.query(fyExpense)));
  }

  /**
   * 通过id查询中南置地-费控报销
   * @param  id
   * @return XfR
   */
  @GetMapping("/fyexpenses/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fyExpenseServiceImpl.getById(id));
  }

  /**
   * 新增中南置地-费控报销
   * @param fyExpense 中南置地-费控报销
   * @return XfR
   */
  @PostMapping("/fyexpenses")
  public XfR save(@RequestBody FyExpense fyExpense) {
     return XfR.ok(fyExpenseServiceImpl.save(fyExpense));
  }

  /**
   * 修改-传入修改后的全部数据中南置地-费控报销
   * @param fyExpense 中南置地-费控报销
   * @return XfR
   */
  @PutMapping("/fyexpenses/{id}")
  public XfR putUpdate(@RequestBody FyExpense fyExpense,@PathVariable Long id) {
      fyExpense.setId(id);
      return XfR.ok(fyExpenseServiceImpl.updateById(fyExpense));
  }

  /**
   * 修改-传入修改的数据中南置地-费控报销
   * @param fyExpense 中南置地-费控报销
   * @return XfR
   */
  @PatchMapping("/fyexpenses/{id}")
  public XfR patchUpdate(@RequestBody FyExpense fyExpense,@PathVariable Long id) {
      FyExpense upfyExpense = fyExpenseServiceImpl.getById(id);
      if(upfyExpense != null){
        upfyExpense = ObjectCopyUtils.copyProperties(fyExpense,upfyExpense,true);
      }
      return XfR.ok(fyExpenseServiceImpl.updateById(upfyExpense));
  }

  /**
   * 通过id删除中南置地-费控报销
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fyexpenses/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fyExpenseServiceImpl.removeById(id));
  }

  @PostMapping("/fyexpenses/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fy_expense");
     params.put("request", condition);

     return XfR.ok(fyExpenseServiceImpl.querys(params));
  }

}
