package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.ImageFile;
import com.xforceplus.imagesaas.service.IImageFileService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 影像文件前端控制器
 *
 * @author ultraman
 * @date 2023-07-31
 */
@RestController
public class ImageFileController {

  @Autowired
  private IImageFileService imageFileServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param imageFile 影像文件
   * @return
   */
  @GetMapping("/imagefiles" )
  public XfR getImageFiles(XfPage page, ImageFile imageFile) {
    return XfR.ok(imageFileServiceImpl.page(page, Wrappers.query(imageFile)));
  }

  /**
   * 通过id查询影像文件
   * @param  id
   * @return XfR
   */
  @GetMapping("/imagefiles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(imageFileServiceImpl.getById(id));
  }

  /**
   * 新增影像文件
   * @param imageFile 影像文件
   * @return XfR
   */
  @PostMapping("/imagefiles")
  public XfR save(@RequestBody ImageFile imageFile) {
     return XfR.ok(imageFileServiceImpl.save(imageFile));
  }

  /**
   * 修改-传入修改后的全部数据影像文件
   * @param imageFile 影像文件
   * @return XfR
   */
  @PutMapping("/imagefiles/{id}")
  public XfR putUpdate(@RequestBody ImageFile imageFile,@PathVariable Long id) {
      imageFile.setId(id);
      return XfR.ok(imageFileServiceImpl.updateById(imageFile));
  }

  /**
   * 修改-传入修改的数据影像文件
   * @param imageFile 影像文件
   * @return XfR
   */
  @PatchMapping("/imagefiles/{id}")
  public XfR patchUpdate(@RequestBody ImageFile imageFile,@PathVariable Long id) {
      ImageFile upimageFile = imageFileServiceImpl.getById(id);
      if(upimageFile != null){
        upimageFile = ObjectCopyUtils.copyProperties(imageFile,upimageFile,true);
      }
      return XfR.ok(imageFileServiceImpl.updateById(upimageFile));
  }

  /**
   * 通过id删除影像文件
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/imagefiles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(imageFileServiceImpl.removeById(id));
  }

  @PostMapping("/imagefiles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "image_file");
     params.put("request", condition);

     return XfR.ok(imageFileServiceImpl.querys(params));
  }

}
