package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.BillTicketRelation;
import com.xforceplus.imagesaas.service.IBillTicketRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-06
 */
@RestController
public class BillTicketRelationController {

  @Autowired
  private IBillTicketRelationService billTicketRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billTicketRelation ${table.comment}
   * @return
   */
  @GetMapping("/billticketrelations" )
  public XfR getBillTicketRelations(XfPage page, BillTicketRelation billTicketRelation) {
    return XfR.ok(billTicketRelationServiceImpl.page(page, Wrappers.query(billTicketRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billticketrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billTicketRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billTicketRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/billticketrelations")
  public XfR save(@RequestBody BillTicketRelation billTicketRelation) {
     return XfR.ok(billTicketRelationServiceImpl.save(billTicketRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billTicketRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/billticketrelations/{id}")
  public XfR putUpdate(@RequestBody BillTicketRelation billTicketRelation,@PathVariable Long id) {
      billTicketRelation.setId(id);
      return XfR.ok(billTicketRelationServiceImpl.updateById(billTicketRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billTicketRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billticketrelations/{id}")
  public XfR patchUpdate(@RequestBody BillTicketRelation billTicketRelation,@PathVariable Long id) {
      BillTicketRelation upbillTicketRelation = billTicketRelationServiceImpl.getById(id);
      if(upbillTicketRelation != null){
        upbillTicketRelation = ObjectCopyUtils.copyProperties(billTicketRelation,upbillTicketRelation,true);
      }
      return XfR.ok(billTicketRelationServiceImpl.updateById(upbillTicketRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billticketrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billTicketRelationServiceImpl.removeById(id));
  }

  @PostMapping("/billticketrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_ticket_relation");
     params.put("request", condition);

     return XfR.ok(billTicketRelationServiceImpl.querys(params));
  }

}
