package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicket;
import com.xforceplus.imagesaas.service.ICompareTicketService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的单证父类前端控制器
 *
 * @author ultraman
 * @date 2023-03-06
 */
@RestController
public class CompareTicketController {

  @Autowired
  private ICompareTicketService compareTicketServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicket 数据比对用途的单证父类
   * @return
   */
  @GetMapping("/comparetickets" )
  public XfR getCompareTickets(XfPage page, CompareTicket compareTicket) {
    return XfR.ok(compareTicketServiceImpl.page(page, Wrappers.query(compareTicket)));
  }

  /**
   * 通过id查询数据比对用途的单证父类
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparetickets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的单证父类
   * @param compareTicket 数据比对用途的单证父类
   * @return XfR
   */
  @PostMapping("/comparetickets")
  public XfR save(@RequestBody CompareTicket compareTicket) {
     return XfR.ok(compareTicketServiceImpl.save(compareTicket));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的单证父类
   * @param compareTicket 数据比对用途的单证父类
   * @return XfR
   */
  @PutMapping("/comparetickets/{id}")
  public XfR putUpdate(@RequestBody CompareTicket compareTicket,@PathVariable Long id) {
      compareTicket.setId(id);
      return XfR.ok(compareTicketServiceImpl.updateById(compareTicket));
  }

  /**
   * 修改-传入修改的数据数据比对用途的单证父类
   * @param compareTicket 数据比对用途的单证父类
   * @return XfR
   */
  @PatchMapping("/comparetickets/{id}")
  public XfR patchUpdate(@RequestBody CompareTicket compareTicket,@PathVariable Long id) {
      CompareTicket upcompareTicket = compareTicketServiceImpl.getById(id);
      if(upcompareTicket != null){
        upcompareTicket = ObjectCopyUtils.copyProperties(compareTicket,upcompareTicket,true);
      }
      return XfR.ok(compareTicketServiceImpl.updateById(upcompareTicket));
  }

  /**
   * 通过id删除数据比对用途的单证父类
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparetickets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketServiceImpl.removeById(id));
  }

  @PostMapping("/comparetickets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket");
     params.put("request", condition);

     return XfR.ok(compareTicketServiceImpl.querys(params));
  }

}
