package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketMedical;
import com.xforceplus.imagesaas.service.ICompareTicketMedicalService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 比对医疗票据前端控制器
 *
 * @author ultraman
 * @date 2023-03-06
 */
@RestController
public class CompareTicketMedicalController {

  @Autowired
  private ICompareTicketMedicalService compareTicketMedicalServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketMedical 比对医疗票据
   * @return
   */
  @GetMapping("/compareticketmedicals" )
  public XfR getCompareTicketMedicals(XfPage page, CompareTicketMedical compareTicketMedical) {
    return XfR.ok(compareTicketMedicalServiceImpl.page(page, Wrappers.query(compareTicketMedical)));
  }

  /**
   * 通过id查询比对医疗票据
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketmedicals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketMedicalServiceImpl.getById(id));
  }

  /**
   * 新增比对医疗票据
   * @param compareTicketMedical 比对医疗票据
   * @return XfR
   */
  @PostMapping("/compareticketmedicals")
  public XfR save(@RequestBody CompareTicketMedical compareTicketMedical) {
     return XfR.ok(compareTicketMedicalServiceImpl.save(compareTicketMedical));
  }

  /**
   * 修改-传入修改后的全部数据比对医疗票据
   * @param compareTicketMedical 比对医疗票据
   * @return XfR
   */
  @PutMapping("/compareticketmedicals/{id}")
  public XfR putUpdate(@RequestBody CompareTicketMedical compareTicketMedical,@PathVariable Long id) {
      compareTicketMedical.setId(id);
      return XfR.ok(compareTicketMedicalServiceImpl.updateById(compareTicketMedical));
  }

  /**
   * 修改-传入修改的数据比对医疗票据
   * @param compareTicketMedical 比对医疗票据
   * @return XfR
   */
  @PatchMapping("/compareticketmedicals/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketMedical compareTicketMedical,@PathVariable Long id) {
      CompareTicketMedical upcompareTicketMedical = compareTicketMedicalServiceImpl.getById(id);
      if(upcompareTicketMedical != null){
        upcompareTicketMedical = ObjectCopyUtils.copyProperties(compareTicketMedical,upcompareTicketMedical,true);
      }
      return XfR.ok(compareTicketMedicalServiceImpl.updateById(upcompareTicketMedical));
  }

  /**
   * 通过id删除比对医疗票据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketmedicals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketMedicalServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketmedicals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_medical");
     params.put("request", condition);

     return XfR.ok(compareTicketMedicalServiceImpl.querys(params));
  }

}
