package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.FyFHtfk;
import com.xforceplus.imagesaas.service.IFyFHtfkService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 中南置地-费控非合同付款前端控制器
 *
 * @author ultraman
 * @date 2023-03-06
 */
@RestController
public class FyFHtfkController {

  @Autowired
  private IFyFHtfkService fyFHtfkServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fyFHtfk 中南置地-费控非合同付款
   * @return
   */
  @GetMapping("/fyfhtfks" )
  public XfR getFyFHtfks(XfPage page, FyFHtfk fyFHtfk) {
    return XfR.ok(fyFHtfkServiceImpl.page(page, Wrappers.query(fyFHtfk)));
  }

  /**
   * 通过id查询中南置地-费控非合同付款
   * @param  id
   * @return XfR
   */
  @GetMapping("/fyfhtfks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fyFHtfkServiceImpl.getById(id));
  }

  /**
   * 新增中南置地-费控非合同付款
   * @param fyFHtfk 中南置地-费控非合同付款
   * @return XfR
   */
  @PostMapping("/fyfhtfks")
  public XfR save(@RequestBody FyFHtfk fyFHtfk) {
     return XfR.ok(fyFHtfkServiceImpl.save(fyFHtfk));
  }

  /**
   * 修改-传入修改后的全部数据中南置地-费控非合同付款
   * @param fyFHtfk 中南置地-费控非合同付款
   * @return XfR
   */
  @PutMapping("/fyfhtfks/{id}")
  public XfR putUpdate(@RequestBody FyFHtfk fyFHtfk,@PathVariable Long id) {
      fyFHtfk.setId(id);
      return XfR.ok(fyFHtfkServiceImpl.updateById(fyFHtfk));
  }

  /**
   * 修改-传入修改的数据中南置地-费控非合同付款
   * @param fyFHtfk 中南置地-费控非合同付款
   * @return XfR
   */
  @PatchMapping("/fyfhtfks/{id}")
  public XfR patchUpdate(@RequestBody FyFHtfk fyFHtfk,@PathVariable Long id) {
      FyFHtfk upfyFHtfk = fyFHtfkServiceImpl.getById(id);
      if(upfyFHtfk != null){
        upfyFHtfk = ObjectCopyUtils.copyProperties(fyFHtfk,upfyFHtfk,true);
      }
      return XfR.ok(fyFHtfkServiceImpl.updateById(upfyFHtfk));
  }

  /**
   * 通过id删除中南置地-费控非合同付款
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fyfhtfks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fyFHtfkServiceImpl.removeById(id));
  }

  @PostMapping("/fyfhtfks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fy_f_htfk");
     params.put("request", condition);

     return XfR.ok(fyFHtfkServiceImpl.querys(params));
  }

}
