package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.TaskQueue;
import com.xforceplus.imagesaas.service.ITaskQueueService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 任务队列前端控制器
 *
 * @author ultraman
 * @date 2023-03-06
 */
@RestController
public class TaskQueueController {

  @Autowired
  private ITaskQueueService taskQueueServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taskQueue 任务队列
   * @return
   */
  @GetMapping("/taskqueues" )
  public XfR getTaskQueues(XfPage page, TaskQueue taskQueue) {
    return XfR.ok(taskQueueServiceImpl.page(page, Wrappers.query(taskQueue)));
  }

  /**
   * 通过id查询任务队列
   * @param  id
   * @return XfR
   */
  @GetMapping("/taskqueues/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taskQueueServiceImpl.getById(id));
  }

  /**
   * 新增任务队列
   * @param taskQueue 任务队列
   * @return XfR
   */
  @PostMapping("/taskqueues")
  public XfR save(@RequestBody TaskQueue taskQueue) {
     return XfR.ok(taskQueueServiceImpl.save(taskQueue));
  }

  /**
   * 修改-传入修改后的全部数据任务队列
   * @param taskQueue 任务队列
   * @return XfR
   */
  @PutMapping("/taskqueues/{id}")
  public XfR putUpdate(@RequestBody TaskQueue taskQueue,@PathVariable Long id) {
      taskQueue.setId(id);
      return XfR.ok(taskQueueServiceImpl.updateById(taskQueue));
  }

  /**
   * 修改-传入修改的数据任务队列
   * @param taskQueue 任务队列
   * @return XfR
   */
  @PatchMapping("/taskqueues/{id}")
  public XfR patchUpdate(@RequestBody TaskQueue taskQueue,@PathVariable Long id) {
      TaskQueue uptaskQueue = taskQueueServiceImpl.getById(id);
      if(uptaskQueue != null){
        uptaskQueue = ObjectCopyUtils.copyProperties(taskQueue,uptaskQueue,true);
      }
      return XfR.ok(taskQueueServiceImpl.updateById(uptaskQueue));
  }

  /**
   * 通过id删除任务队列
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taskqueues/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taskQueueServiceImpl.removeById(id));
  }

  @PostMapping("/taskqueues/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "task_queue");
     params.put("request", condition);

     return XfR.ok(taskQueueServiceImpl.querys(params));
  }

}
