package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.TicketBus;
import com.xforceplus.imagesaas.service.ITicketBusService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-06
 */
@RestController
public class TicketBusController {

  @Autowired
  private ITicketBusService ticketBusServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketBus ${table.comment}
   * @return
   */
  @GetMapping("/ticketbuss" )
  public XfR getTicketBuss(XfPage page, TicketBus ticketBus) {
    return XfR.ok(ticketBusServiceImpl.page(page, Wrappers.query(ticketBus)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketbuss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketBusServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketBus ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketbuss")
  public XfR save(@RequestBody TicketBus ticketBus) {
     return XfR.ok(ticketBusServiceImpl.save(ticketBus));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketBus ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketbuss/{id}")
  public XfR putUpdate(@RequestBody TicketBus ticketBus,@PathVariable Long id) {
      ticketBus.setId(id);
      return XfR.ok(ticketBusServiceImpl.updateById(ticketBus));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketBus ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketbuss/{id}")
  public XfR patchUpdate(@RequestBody TicketBus ticketBus,@PathVariable Long id) {
      TicketBus upticketBus = ticketBusServiceImpl.getById(id);
      if(upticketBus != null){
        upticketBus = ObjectCopyUtils.copyProperties(ticketBus,upticketBus,true);
      }
      return XfR.ok(ticketBusServiceImpl.updateById(upticketBus));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketbuss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketBusServiceImpl.removeById(id));
  }

  @PostMapping("/ticketbuss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_bus");
     params.put("request", condition);

     return XfR.ok(ticketBusServiceImpl.querys(params));
  }

}
