package com.xforceplus.imageservicesaas.controller;


/**
 * 数据对比用途的影像feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CompareImage;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareImageFeignApi {

  /**
   * 通过id查询数据对比用途的影像
   * @param  id
   * @return R
   */
  @GetMapping("/compareImage/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据对比用途的影像
   * @param compareImage 数据对比用途的影像
   * @return R
   */
  @PostMapping("/compareImage/add")
  public R save(@RequestBody CompareImage compareImage);

  /**
   * 修改数据对比用途的影像
   * @param compareImage 数据对比用途的影像
   * @return R
   */
  @PostMapping("/compareImage/update")
  public R updateById(@RequestBody CompareImage compareImage);

  /**
   * 通过id删除数据对比用途的影像
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareImage/del/{id}" )
  public R removeById(@PathVariable Long id);

}